const mongoose = require('mongoose');

const nurseApplicationSchema = new mongoose.Schema({
  fullName: { type: String, required: true },
  email: { type: String, required: true },
  phoneNumber: { type: String, required: true },
  age: { type: Number, required: true },
  nationality: { type: String, required: true },
  location: { type: String, required: true },
  positionApplied: { type: String, required: true },
  yearsOfExperience: { type: Number, required: true },
  currentJobTitle: { type: String, required: true },
  currentCompany: { type: String, required: true },
  currentSalary: { type: String, required: true },
  expectedSalary: { type: String, required: true },
  desiredAllowance: { type: String, required: true },
  levelOfEducation: { type: String, required: true },
  nursingLicense: { type: String,
    enum:[
      "Yes",
      "No"
    ],
     required: true }, 
  highestEducation: { type: String,
    enum: [
      "Doctorate(PhD)",
      "Master's Degree",
      "Postgraduate Diploma",
      "Bachelor’s Degree",
      "Bachelor's Degree",
      "Higher Diploma",
      "Diploma",
      "Professional Certificate",
      "Certificate",
      "others",
    ],
     required: true },
  cvFileId: { type: mongoose.Schema.Types.ObjectId, ref: 'fs.files' },
  
},{ timestamps: true },);

const NurseApplication = mongoose.model('NurseApplication', nurseApplicationSchema);

module.exports = NurseApplication;
