const express = require('express');
const multer = require('multer');
const path = require('path');
const app = express();

// Set up file storage for uploaded certificates
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, 'uploads/');
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + path.extname(file.originalname)); // Unique filename
  },
});
const upload = multer({ storage });

app.use(express.json());
app.use(express.static('public'));

// Mock database (in-memory)
let certificates = [];

// Endpoint to fetch certificates
app.get('/api/certificates', (req, res) => {
  res.json(certificates);
});

// Endpoint to save a certificate (with file upload)
app.post('/api/certificates', upload.single('file'), (req, res) => {
  const { name, organization, date } = req.body;
  const fileUrl = req.file ? `/uploads/${req.file.filename}` : null;
  const newCertificate = {
    name,
    organization,
    date,
    file: req.file ? req.file.filename : null,
    fileUrl,
  };
  certificates.push(newCertificate); // Save to the "database"
  res.status(201).json(newCertificate); // Return the saved certificate
});

// Start server
app.listen(5000, () => {
  console.log('Server is running on port 5000');
});
