// models/UserProfile.js

const mongoose = require('mongoose');

const userProfileSchema = new mongoose.Schema({
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
  firstName: String,
  lastName: String,
  secondName: String,
  idNumber: String,
  whatsAppNo: String,
  phoneNumber: String,
  email: String,
  age: Number,
  nationality: String,
  location: String,
  specialization: String,
  positionApplied: String,
  academicLevel: String,
  salaryInfo: String,
  workExperience: [
    {
      company: String,
      position: String,
      duration: String,
    }
  ],
  createdAt: { type: Date, default: Date.now },
});

const UserProfile = mongoose.model('UserProfile', userProfileSchema);
module.exports = UserProfile;
