const express = require("express");
const router = express.Router();
const User = require("../models/User");

router.post("/profileUpdate", async (req, res) => {
    try {
        const user = await User.findById(req.user.userId);
        if (user) {
            user.username = req.body.username || user.username;
            user.email = req.body.email || user.email;
            user.pic = req.body.pic || user.pic;  

            if (req.body.password) {
                user.password = req.body.password;
            }

            const updatedUser = await user.save();  

            res.json({
                userId: updatedUser.userId,
                username: updatedUser.username,
                email: updatedUser.email,
                pic: updatedUser.pic
            });
        } else {
            res.status(404).json({ message: "User not found" });
        }
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
});

module.exports = router;
